{********************************************
; File: HyperXCMD.p
;
; For use with HyperCardIIGS Version 1.0
;
; Copyright Apple Computer, Inc. 1990
; All Rights Reserved
;
********************************************}

UNIT HyperXCMD;

INTERFACE

USES Types,
     QuickDraw;

CONST _CallBackVector = $E10220;

TYPE Str19 = String[19];
     Str31 = String[31];

     XCmdPtr = ^XCmdBlock;
     XCmdBlock = RECORD
		   paramCount:	INTEGER;
		   params:		ARRAY[1..16] OF Handle;
		   returnValue:	Handle;
		   passFlag:	BOOLEAN;
		   userID:		INTEGER;
		   returnStat:	INTEGER;	{ 0 if normal return, 1 for error }
		 END;


PROCEDURE BeginXSound;
INLINE $A2,$0029,$22,_CallBackVector;

FUNCTION BoolToStr (bool: BOOLEAN): Str31;
INLINE $A2,$0010,$22,_CallBackVector;

PROCEDURE ChangedMaskAndData(whatChanged: INTEGER);
INLINE $A2,$002C,$22,_CallBackVector;

FUNCTION CopyGSString (src: GSString255Hndl): GSString255Hndl;
INLINE $A2,$0020,$22,_CallBackVector;

PROCEDURE EndXSound;
INLINE $A2,$002A,$22,_CallBackVector;

FUNCTION EvalExpr (expr: Str255): Handle;
INLINE $A2,$0002,$22,_CallBackVector;

FUNCTION ExtToStr (extendedNumber: Extended): Str31;
INLINE $A2,$0011,$22,_CallBackVector;

FUNCTION FindNamedResource (resourceType: INTEGER; resourceName: Str255;
							VAR theFile: INTEGER; VAR resourceID: Longint): BOOLEAN;
INLINE $A2,$0026,$22,_CallBackVector;

FUNCTION GetFieldByID (cardFieldFlag: BOOLEAN; fieldID: INTEGER): Handle;
INLINE $A2,$0016,$22,_CallBackVector;

FUNCTION GetFieldByName (cardFieldFlag: BOOLEAN; fieldName: Str255): Handle;
INLINE $A2,$0014,$22,_CallBackVector;

FUNCTION GetFieldByNum (cardFieldFlag: BOOLEAN; fieldNum: INTEGER): Handle;
INLINE $A2,$0015,$22,_CallBackVector;

FUNCTION GetGlobal (globName: Str255): Handle;
INLINE $A2,$0012,$22,_CallBackVector;

PROCEDURE GetMaskAndData(VAR mask: LocInfo; VAR data: LocInfo);
INLINE $A2,$002B,$22,_CallBackVector;

FUNCTION GetResourceName (resourceType: INTEGER; resourceID: Longint): Str255;
INLINE $A2,$0028,$22,_CallBackVector;

FUNCTION GSConcat (src1: GSString255Hndl; src2: GSString255Hndl): GSString255Hndl;
INLINE $A2,$0021,$22,_CallBackVector;

FUNCTION GSStringEqual (src1: GSString255Hndl; src2: GSString255Hndl): BOOLEAN;
INLINE $A2,$0022,$22,_CallBackVector;

FUNCTION GSToPString (src: GSString255Hndl): Str255;
INLINE $A2,$001E,$22,_CallBackVector;

FUNCTION GSToZero (src: GSString255Hndl): Handle;
INLINE $A2,$0023,$22,_CallBackVector;

FUNCTION LoadNamedResource (resourceType: INTEGER; resourceName: Str255): Handle;
INLINE $A2,$0025,$22,_CallBackVector;

FUNCTION LongToStr (posNum: Longint): Str31;
INLINE $A2,$000D,$22,_CallBackVector;

FUNCTION NumToHex (longNumber: Longint; nDigits: INTEGER): Str31;
INLINE $A2,$000F,$22,_CallBackVector;

FUNCTION NumToStr (longNumber: Longint): Str31;
INLINE $A2,$000E,$22,_CallBackVector;

FUNCTION PasToZero (str: Str255): Handle;
INLINE $A2,$0007,$22,_CallBackVector;

FUNCTION PToGSString (src: Str255): GSString255Hndl;
INLINE $A2,$001F,$22,_CallBackVector;

PROCEDURE ReturnToPas (zeroStr: Ptr; VAR pasStr: Str255);
INLINE $A2,$001B,$22,_CallBackVector;

PROCEDURE ScanToReturn (VAR scanPtr: Ptr);
INLINE $A2,$001C,$22,_CallBackVector;

PROCEDURE ScanToZero (VAR scanPtr: Ptr);
INLINE $A2,$001D,$22,_CallBackVector;

PROCEDURE SendCardMessage (msg: Str255);
INLINE $A2,$0001,$22,_CallBackVector;

PROCEDURE SendHCMessage (msg: Str255);
INLINE $A2,$0005,$22,_CallBackVector;

PROCEDURE SetFieldByID (cardFieldFlag: BOOLEAN; fieldID: INTEGER; fieldVal: Handle);
INLINE $A2,$0019,$22,_CallBackVector;

PROCEDURE SetFieldByName (cardFieldFlag: BOOLEAN; fieldNName: Str255; fieldVal: Handle);
INLINE $A2,$0017,$22,_CallBackVector;

PROCEDURE SetFieldByNum (cardFieldFlag: BOOLEAN; fieldNum: INTEGER; fieldVal: Handle);
INLINE $A2,$0018,$22,_CallBackVector;

PROCEDURE SetGlobal (globName: Str255; globValue: Handle);
INLINE $A2,$0013,$22,_CallBackVector;

PROCEDURE SetResourceName (resourceType: INTEGER; resourceID: Longint; resourceName: Str255);
INLINE $A2,$0027,$22,_CallBackVector;

FUNCTION StringEqual (str1: Str255; str2: Str255): BOOLEAN;
INLINE $A2,$001A,$22,_CallBackVector;

FUNCTION StringLength (strPtr: Ptr): Longint;
INLINE $A2,$0003,$22,_CallBackVector;

FUNCTION StringMatch (stringPattern: Str255; target: Ptr): Ptr;
INLINE $A2,$0004,$22,_CallBackVector;

FUNCTION StrToBool (str: Str31): BOOLEAN;
INLINE $A2,$000B,$22,_CallBackVector;

FUNCTION StrToExt (str: Str31): Extended;
INLINE $A2,$000C,$22,_CallBackVector;

FUNCTION StrToLong (str: Str31): Longint;
INLINE $A2,$0009,$22,_CallBackVector;

FUNCTION StrToNum (str: Str31): Longint;
INLINE $A2,$000A,$22,_CallBackVector;

PROCEDURE ZeroBytes (dstPtr: Ptr; longCount: Longint);
INLINE $A2,$0006,$22,_CallBackVector;

FUNCTION ZeroToGS (src: Handle): GSString255Hndl;
INLINE $A2,$0024,$22,_CallBackVector;

PROCEDURE ZeroToPas (zeroStr: Ptr; VAR pasStr: Str255);
INLINE $A2,$0008,$22,_CallBackVector;


IMPLEMENTATION
END.
